// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef EXI_MEMCARD_H
#define EXI_MEMCARD_H

#include "hw_ei.h"
#include "file.h"

class EXIDevice_Memcard : public EXIDevice {
public:
	EXIDevice_Memcard(EXIInterruptRaiser& eir, MemcardType type,
		const std::string& filename, bool caching);
	~EXIDevice_Memcard();
	EXIResultValue writeImm(DWORD size, DWORD data);
	EXIResultValue writeDMA(DWORD size, DWORD address, MemInterface &mem);
	EXIResultValue readImm(DWORD size, DWORD &data);
	EXIResultValue readDMA(DWORD size, DWORD address, MemInterface &mem);
	void notify_deselected();

	MemcardType getType() { return m_type; }
	const std::string& getFilename() { return m_filename; }
	bool getCaching() { return m_caching; }
	bool setCaching(bool caching);

	EXIInterruptRaiser& interrupt;
private:
	Container<BYTE> cardmemory;
	WriteBuffer write_buffer;
	enum MemcardStates { Ready, ExpectingSingleImmRead, ExpectingRead, ExpectingWrite,
		ExpectingLatency };
	MemcardStates state;
	DWORD imm_output;
	DWORD m_offset;
	MemcardType m_type;
	std::string m_filename;
	bool m_caching;
	File m_file;

	//void do_exiinthack();
	bool construct();
	bool destruct();
	bool flush();
	void readCard(DWORD offset, DWORD size, void *dst);
	void writeCard(DWORD offset, DWORD size, void *src);
};

#endif	//EXI_MEMCARD_H
